/* drone didactique D2C :
ce programme génère des créneaux pour l'identification de la fonction de transfert du moteur droit

Nota : la période d'échantillonnage est fixée à 20 ms (constante "periode_echantillonnage")
par le fait que la bibliothèque "servo" régénère la commande des moteurs toutes les 20 ms.

**** câblage des entrées sorties de l'arduino : ****
broche masse du D2C sur                     GND arduino
broche commande du moteur droit du D2C sur  sortie numérique 8 arduino
broche commande du moteur gauche du D2C sur  sortie numérique 7 arduino  (peut être déconnectée pour la manipulation sur le moteur droit)

- tous droits réservés - François WEISS - pour DMS -
*/

// variables pour la commande programmée d'échelons qui se répètent :
int amplitude_echelon = 10;         // amplitude prévue pour l'échelon de commande moteur (en points de calculateur 10 bits : 0 à 1023)
int point_fonctionnement = 400;      // le point de fonctionnement de vitesse = le point de départ de l'écheleon (en points de calculateur 10 bits : 0 à 1023) 
long temps_echelon = 2;              // temps en secondes prévu pour la réalisation de l'échelon
long temps_debut_mesure_echelon = 0;       // variable pour le calcul du temps de l'échelon
long temps_mesure_echelon = 0;       // variable pour le calcul du temps de l'échelon
int echelon = 0;                     // variable pour définir le niveau haut ou bas de la commande
             
//*************** vitesse du port serie (pour tests et affichage)
unsigned int vitesse_port = 57600;                 // variable pour activer la lecture sur le port série et transmettre des valeurs vers le PC (pour contrôle)
                                                 // à régler à l'identique dans la fenêtre "serial monitor" de l'interface de programmation Arduino (et processing ).
// ******************* variables pour gerer le cycle
unsigned int nb_cycles = 0;                      // variable pour compter le nombre de cycles : utilisé pour ne pas générer des sorties sur le port série à chaque cycle
long temps_debut_cycle = 0;                      // pour la mesure du temps de cycle de l'asservissement
int temps_cycle_calcule = 0;                     // pour la mesure du temps de cycle de l'asservissement
float ecart = 0;                               // différence entre consigne potentiomètre et mesure accéléro pour la boucle d'asservissement (de -1023 à + 1023)
float commande = 0;                            // ecart brut traité par le correcteur = commande
float pi=3.141597;

//************** variables pour le fonctionnement du cycle *****************************************
long periode_echantillonnage = 20;   // période d'exécution de la boucle principale (en millisecondes) ;

//*********** variables pour le fonctionnement des moteurs :
#include <Servo.h>                    // on utilise la bibliothèque (ou la classe) "Servo"
Servo moteur_brushless_gauche;        // créé un "objet" nommé "moteur_brushless_gauche" dans la classe "Servo"
Servo moteur_brushless_droit;        // créé un "objet" nommé "moteur_brushless_droit" dans la classe "Servo"
float creneau_min = 1100;          // définit la valeur en microsecondes de la largeur d'impulsion minimale pour le contrôleur utilisé ;
float creneau_max = 1700;          // définit la valeur en microsecondes de la largeur d'impulsion maximale pour le contrôleur utilisé ;
                                   // (adaptation à chaque type de moteur+contrôleur en fonction de valeur "creneau_min" et "creneau_max")
float amplitude_max_creneau = creneau_max - creneau_min;
float valeur_nominale_creneau = creneau_min;   //initialisation de variable pour définir la valeur en milliseconde de largeur créneau pour obtenir la vitesse moyenne d'un moteur
float commande_unitarisee = 0.5;               // variable pour ramener la variation de consigne tangage sur une échelle de 0 à 1 (initialement de 0 à 1023 ); initialisée à la valeur milieu
float commande_gaz_unitarisee = 0;             // variable pour ramener la variation de consigne gaz sur une échelle de -1 à 1 (initialement de 0 à 1023 ); initialisée à la valeur minimum
float creneau_gauche = creneau_min;            // variable pour mémoriser la commande à envoyer vers le servo (entre pulsmin et pulsemax)
float creneau_droit = creneau_min;            // variable pour mémoriser la commande à envoyer vers le servo (entre pulsmin et pulsemax)

//****************************************************************************************************************************************************
//setup = déclaration des actions nécessaires au démarrage (traité une seule fois au lancement du programme)
void setup(){
  Serial.begin(vitesse_port);                   // mise en route du port série à la vitesse choisie dans "vitesseport"
  moteur_brushless_droit.attach(8);             // utilise la méthode "attach" de la classe Servo pour affecter la commande à la broche numérique 8 de l'arduino
  moteur_brushless_gauche.attach(7);            // utilise la méthode "attach" de la classe Servo pour affecter la commande à la broche numérique 7 de l'arduino
  temps_debut_mesure_echelon = micros();        // pour le calcul de la durée de l'échelon  
}

//******************************************************************************************************************************************************
//boucle principale
void loop(){
  temps_debut_cycle = micros();                   // pour le calcul et la fixation du temps de cycle 

  // gestion de la répétabilité de l'échelon
  temps_mesure_echelon = micros() - temps_debut_mesure_echelon;
  if (temps_mesure_echelon < temps_echelon*1000000) {
    echelon = 0; 
  }
  else if ((temps_mesure_echelon >= temps_echelon*1000000) && (temps_mesure_echelon < 2 * temps_echelon*1000000)) {  
    echelon = 1; 
  }
  else {  
    echelon = 0;
    temps_debut_mesure_echelon = micros();                 // pour le calcul de la durée d'un nouvel échelon;
  }

  //******************traitement de la commande
  if (echelon == 1) {
    commande = float(amplitude_echelon);
  } 
  else commande = 0;
  commande_unitarisee = commande / 50.0f;                 // rééchelonnement de la commande de tangage

  //********************* traitement de la commande des gaz (vitesse nominale des moteurs = point de fonctionnement):
  commande_gaz_unitarisee = float(point_fonctionnement) / 1023.0f;       // rééchelonnement de la commande de gaz : valeur de la commande (0 à 1023) ramenée sur une échelle de 0 à 1
  valeur_nominale_creneau = creneau_min + (amplitude_max_creneau * commande_gaz_unitarisee) ;  // créneau nominal généré par la commande des gaz à partir de la valeur de potentio

  //******************************** commande des moteurs *****************************************************
  creneau_gauche = valeur_nominale_creneau + (amplitude_max_creneau * commande_unitarisee);      // calcul largeur d'impulsion moteur gauche autour de la valeur nominale
  if (creneau_gauche < creneau_min) creneau_gauche = creneau_min ;                               // on limite à des valeurs autorisées par la carte de puissance
  if (creneau_gauche > creneau_max) creneau_gauche = creneau_max ;
  creneau_droit = valeur_nominale_creneau - (amplitude_max_creneau * commande_unitarisee);      // calcul largeur d'impulsion moteur droit autour de la valeur nominale
  if (creneau_droit < creneau_min) creneau_droit = creneau_min ;                                // on limite à des valeurs autorisées par la carte de puissance
  if (creneau_droit > creneau_max) creneau_droit = creneau_max ;
  moteur_brushless_gauche.writeMicroseconds(int(creneau_gauche));   // utilise la méthode "writeMicroseconds" de la classe Servo pour générer les créneaux en sortie pour vitesse moteur gauche
  moteur_brushless_droit.writeMicroseconds(int(creneau_droit));     // utilise la méthode "writeMicroseconds" de la classe Servo pour générer les créneaux en sortie pour vitesse moteur droit

  //*********************** envoi sur le port série pour tests, debug et affichage avec processing éventuellement **********************************
  if (nb_cycles >= 10) {
    Serial.print(temps_mesure_echelon);
    Serial.print(",");
    Serial.print(echelon);
    Serial.print(",");   
    Serial.print(int(commande));
    Serial.print(",");
    Serial.print(int(creneau_gauche));  // affichage sur le port série de la valeur en microsecondes de la largeur d'impulson pour vitesse moteur gauche (pour contrôle)
    Serial.print(",");
    Serial.print(int(creneau_droit));   // affichage sur le port série de la valeur en microsecondes de la largeur d'impulson pour vitesse moteur droit (pour contrôle)
    Serial.println();
    nb_cycles = 0;
  } // fin if
  nb_cycles = nb_cycles + 1;

  /* ************* attente du temps de cycle fixé  ********************** */
  do {
    temps_cycle_calcule = micros() - temps_debut_cycle;
  } while (temps_cycle_calcule < (periode_echantillonnage*1000));
  // Serial.println(temps_cycle_calcule);
}// fin de la boucle loop


