/* drone didactique D2C :
ce programme réalise le test des entrées de l'arduino-box associée au drone didactique D2C

**** câblage des entrées sorties de l'arduino : ****
broche masse du D2C sur                     GND arduino
broche gyro Ugyr du D2C sur                 entrée analogique A0 arduino
broche accéléro Uax du D2C sur              entrée analogique A1 arduino 
broche potentio gauche du D2C sur           entrée analogique A2 arduino
broche potentio  droit du D2C sur           entrée analogique A3 arduino
broche "capteur angle pivot" sur            entrée analogique A4 arduino
broche commande du moteur gauche du D2C sur sortie numérique 7 arduino
broche commande du moteur droit du D2C sur  sortie numérique 8 arduino

- tous droits réservés - François WEISS - pour DMS -
*/

//*********** déclaration des variables pour la commande manuelle :
int broche_potentio_gauche = 2;    // variable pour déclarer la broche 2 comme broche où est branché le potentiomètre gauche (commande des gaz)
int mesure_potentio_gauche = 0;    // variable pour récupérer la valeur du potentiomètre gauche (commande des gaz)
int broche_potentio_droit = 3;     // variable pour déclarer la broche 3 comme broche où est branché le potentiomètre droit (commande de tangage)
int mesure_potentio_droit = 512;   // variable pour récupérer la valeur du potentiomètre droit  (commande de tangage)(initialisée à valeur moyenne : 512 environ)

// ************ déclaration des variables pour les capteurs :
int broche_gyro = 0;               // variable pour déclarer la broche 0 comme broche où est branché le capteur "angle pivot"
int mesure_gyro = 512;             // variable pour récupérer la mesure du gyro (initialisée à 512)
int broche_accelero = 1;           // variable pour déclarer la broche 1 comme broche où est branché l'accéléromètre
int mesure_accelero = 0;           // variable pour récupérer la mesure de l'accéléromètre
int broche_angle_pivot = 4;        // variable pour déclarer la broche 4 comme broche où est branché le capteur "angle pivot"
int mesure_angle_pivot = 512;      // variable pour récupérer la mesure du capteur "angle pivot" (initialisée à la valeur moyenne 512 environ)
 
// ******************* variables pour gerer le cycle 
unsigned int nb_cycles = 0;       

//*************** vitesse du port serie (pour tests et affichage)
unsigned int vitesse_port = 57600;               // variable pour activer la lecture sur le port série et transmettre des valeurs vers le PC (pour contrôle)
                                                 // à régler à l'identique dans la fenêtre "serial monitor" de l'interface de programmation Arduino.

//****************************************************************************************************************************************************
//setup = déclaration des actions nécessaires au démarrage (traité une seule fois au lancement du programme)
void setup() {
  Serial.begin(vitesse_port);                   // mise en route du port série à la vitesse choisie dans "vitesseport"
}

//******************************************************************************************************************************************************
//boucle principale qui se répète indéfiniment
void loop() {
  // ************* lecture des entrées capteurs ****************************************
  mesure_gyro=analogRead(broche_gyro);                                 // acquisition de la mesure du gyromètre 
  mesure_accelero = analogRead(broche_accelero);                       // acquisition de la mesure de l'accéléromètre   
  mesure_potentio_gauche = analogRead(broche_potentio_gauche);         // acquisition de la mesure du potentio gauche 
  mesure_potentio_droit = analogRead(broche_potentio_droit);           // acquisition de la mesure du potentio droit
  mesure_angle_pivot = analogRead(broche_angle_pivot);                 // acquisition de la mesure du capteur d'angle pivot

  //*********************** envoi sur le port série pour tests **********************************
  if (nb_cycles >= 10) {                         // on n'affiche que tous les 10 cycles pour ne pas surcharger le port série
    Serial.println("...............je mesure : ");
    //Serial.print(mesure_gyro);           
    //Serial.print(" ; ");
    //Serial.print(mesure_accelero);
    //Serial.print(" ; ");
    //Serial.print(mesure_potentio_gauche);
    //Serial.print(" ; ");
    //Serial.print(mesure_potentio_droit);
    //Serial.print(" ; ");    
    //Serial.print(mesure_angle_pivot);   
    Serial.println();
    nb_cycles = 0;
  } // fin if
nb_cycles = nb_cycles + 1;
delay(10); // on attend une dizaine de millisecondes pour ne pas surcharger le processeur
} // fin de la boucle loop
