/*
 drone didactique D2C : lecture du bus SPI du capteur gyromètre MLX90609 de Melexis
 
Connexions à réaliser entre l'Arduino-Box (Master) et le pupitre du drone didactique (Slave) :
  broche 10 de l'Arduino-box  -->  SS    (cette connexion est facultative car il n'y a qu'un seul capteur en liaison avec le microcontrôleur)
  broche 11 de l'Arduino-box  -->  MOSI  (Master Out - Slave In) 
  broche 12 de l'Arduino-box  -->  MISO  (Master In - Slave Out)
  broche 13 de l'Arduino-box  -->  SCLK  (horloge)

 
 - tous droits réservés - François WEISS - pour DMS - le 18 août 2014
 */

#include <SPI.h>  // chargement de la bibliothèque pour la communication par le bus SPI

// les ordres en binaire pour faire réagir le gyro (voir la fiche technique p14) :
const byte ACTIVATION = 0b10011100;             // (ou 0x9C) commande d'activation du convertisseur analogique numérique du gyromètre (à faire avant conversion)
const byte CONVERSION_VITESSE = 0b10010100;     // (ou 0x94) commande de conversion numérique du signal vitesse angulaire du gyromètre (à faire avant lecture)
const byte CONVERSION_TEMPERATURE = 0b10011100; // (ou 0x9C) commande de conversion numérique du signal température du gyromètre (à faire avant lecture) 
const byte LECTURE = 0b10000000;                // (ou 0x80) commande de lecture du signal gyromètre

unsigned int mesure = 0;
byte octet_en_lecture = 0;
float tension_equivalente = 0;

//---------------------- les actions effectuées une seule fois au lancement du programme -----------------------------------------------
void setup() {
  Serial.begin(57600);          // active le port série de l'arduino
  SPI.begin();                 // démarre la bibliothèque SPI 
  SPI.setBitOrder(MSBFIRST);   // déclare que les bits de poids fort seront transmis en premier (voir fiche technique du gyro p9 et p14) 
  pinMode(10, OUTPUT);         // déclare en sortie la broche 10 de l'Arduino qui commande le SS du capteur gyro
  digitalWrite(10, LOW);       // sélection de la destination de la conversation du bus SPI (capteur connecté à la broche 10) 
  SPI.transfer(ACTIVATION);    // génère la mise en mode actif du convertisseur analogique numérique du gyro
  delay(200);                  // laisse le temps (200 microsecondes) au gyro pour réagir
}

// ---------------------- la boucle qui se répète indéfiniment -------------------------------------------------------------------------
void loop() {
  digitalWrite(10, LOW);            // sélection de la destination de la conversation du bus SPI (capteur connecté à la broche 10 = le gyro)
  SPI.transfer(CONVERSION_VITESSE); // génère la conversion 
  delay(200);                       // laisse le temps (200 microsecondes) au gyro pour effectuer la conversion
  // on va lire successivement les 5 octets du registre mémoire du gyro (la mesure est dans les deux derniers)
  // l'information est donnée sur 11 bits, dans les bits 2 à 12 des deux derniers octets) 
  octet_en_lecture = SPI.transfer(LECTURE);     // lit le premier octet du registre mémoire du gyro (inutile pour lire la mesure) 
  octet_en_lecture = SPI.transfer(LECTURE);     // lit le deuxième octet du registre mémoire du gyro (inutile pour lire la mesure) 
  octet_en_lecture = SPI.transfer(LECTURE);     // lit le troisième octet du registre mémoire du gyro (inutile pour lire la mesure) 
  octet_en_lecture = SPI.transfer(LECTURE);     // lit le quatrième octet du registre mémoire du gyro 
  mesure = octet_en_lecture;
  mesure = mesure << 8;                      // décalage de 8 bits vers la gauche pour placer le quatrième octet en octet de poids fort dans la variable "mesure"  
  octet_en_lecture = SPI.transfer(LECTURE);  // lit le cinquième octet du registre mémoire du gyro
  mesure = mesure | octet_en_lecture;        // insertion du cinquième octet en octet poids faible dans la variable "mesure"  
  mesure = mesure >> 1;                      // décalage d'un bit vers la droite pour suppression du bit de poids le plus faible (voir fiche technique du gyro p14)
  mesure = mesure & 0b0000011111111111;      //extraction des 11 bits de poids faible  
  tension_equivalente = (400 + (25 * float(mesure) / 12))/1000;  // conversion en mesure de tension pour test (voir p12 de la fiche technique) 
  digitalWrite(10, HIGH);                    // fin de la conversation avec le gyro
  Serial.print(" je mesure : ");
  Serial.print(mesure);   
  Serial.print(" --> ");   
  Serial.print(tension_equivalente);   
  Serial.print(" volts ");   
  Serial.println();
}


